# Sender - WhatsApp Bulk Messaging Platform

## Project Overview
A WhatsApp bulk messaging platform similar to respond.io, built with PHP using MVP architecture.

## Technology Stack
- **Backend**: PHP 8.1+
- **Database**: MySQL 8.0+
- **Frontend**: HTML5, CSS3, JavaScript (Vanilla JS + Alpine.js for reactivity)
- **Queue System**: MySQL-based queue with cron job processing
- **WhatsApp API**: WhatsApp Business API (Meta Cloud API)

## Directory Structure

```
sender-app/
├── config/
│   ├── database.php
│   ├── whatsapp.php
│   ├── app.php
│   └── payment.php
├── core/
│   ├── Database.php
│   ├── Router.php
│   ├── Controller.php
│   ├── Model.php
│   ├── View.php
│   └── Session.php
├── app/
│   ├── controllers/
│   │   ├── AuthController.php
│   │   ├── DashboardController.php
│   │   ├── ContactController.php
│   │   ├── TemplateController.php
│   │   ├── CampaignController.php
│   │   ├── InboxController.php
│   │   ├── AnalyticsController.php
│   │   ├── SettingsController.php
│   │   ├── BillingController.php
│   │   └── AdminController.php
│   ├── models/
│   │   ├── User.php
│   │   ├── Contact.php
│   │   ├── Group.php
│   │   ├── Template.php
│   │   ├── Campaign.php
│   │   ├── Message.php
│   │   ├── Conversation.php
│   │   ├── Payment.php
│   │   ├── Subscription.php
│   │   └── Analytics.php
│   └── views/
│       ├── layouts/
│       │   ├── header.php
│       │   ├── footer.php
│       │   ├── sidebar.php
│       │   └── navbar.php
│       ├── auth/
│       │   ├── login.php
│       │   ├── register.php
│       │   └── forgot-password.php
│       ├── dashboard/
│       │   └── index.php
│       ├── contacts/
│       │   ├── index.php
│       │   ├── import.php
│       │   └── segments.php
│       ├── templates/
│       │   ├── index.php
│       │   └── create.php
│       ├── campaigns/
│       │   ├── index.php
│       │   ├── create.php
│       │   └── monitor.php
│       ├── inbox/
│       │   └── index.php
│       ├── analytics/
│       │   └── index.php
│       └── settings/
│           ├── account.php
│           ├── billing.php
│           └── integrations.php
├── public/
│   ├── index.php
│   ├── assets/
│   │   ├── css/
│   │   │   └── style.css
│   │   ├── js/
│   │   │   └── app.js
│   │   └── images/
│   └── uploads/
├── storage/
│   ├── logs/
│   └── cache/
├── install/
│   ├── index.php
│   ├── install.sql
│   └── config-sample.php
├── cron/
│   ├── process-queue.php
│   └── cleanup.php
├── vendor/
├── .htaccess
├── composer.json
└── README.md
```

## Features Implementation Checklist

### Phase 1: Core Setup
- [x] Project structure
- [ ] Installation script
- [ ] Database schema
- [ ] MVP core classes
- [ ] Routing system
- [ ] Authentication system

### Phase 2: User Management
- [ ] User registration/login
- [ ] Password recovery
- [ ] Role-based access control
- [ ] Account settings

### Phase 3: Contact Management
- [ ] Import contacts (CSV, Excel)
- [ ] Extract from WhatsApp groups
- [ ] Contact segmentation
- [ ] Contact export

### Phase 4: Template Management
- [ ] Create templates
- [ ] Template variables
- [ ] Template approval workflow
- [ ] Template library

### Phase 5: Campaign Management
- [ ] Campaign builder
- [ ] Campaign scheduler
- [ ] Bulk sending interface
- [ ] Queue processing
- [ ] Media support

### Phase 6: Communication
- [ ] Inbox/Conversations
- [ ] Reply handling
- [ ] Webhook processing

### Phase 7: Billing & Payments
- [ ] Subscription plans (CFA pricing)
- [ ] Bank transfer integration
- [ ] MTN Mobile Money
- [ ] Orange Money
- [ ] Payment verification

### Phase 8: Analytics & Reporting
- [ ] Dashboard metrics
- [ ] Campaign analytics
- [ ] Delivery reports
- [ ] Export reports

### Phase 9: Admin Features
- [ ] Feature toggles
- [ ] User management
- [ ] System settings
- [ ] API configuration

## WhatsApp API Setup Guide

### Getting WhatsApp Business API Credentials

1. **Meta Business Account**
   - URL: https://business.facebook.com/
   - Create a Meta Business Account
   - Verify your business

2. **WhatsApp Business API Access**
   - URL: https://developers.facebook.com/
   - Go to Meta for Developers
   - Create an App → Business → WhatsApp
   - Add WhatsApp product to your app

3. **Required Credentials**
   - Phone Number ID
   - WhatsApp Business Account ID
   - Access Token (Temporary & Permanent)
   - Webhook Verify Token (you create this)
   - App Secret

4. **Setup Steps**
   - Add a phone number to your WhatsApp Business Account
   - Configure webhook URL for receiving messages
   - Get your API credentials from App Dashboard
   - Test with the API Explorer tool

5. **Important URLs**
   - Developers Console: https://developers.facebook.com/apps/
   - WhatsApp Manager: https://business.facebook.com/wa/manage/
   - API Documentation: https://developers.facebook.com/docs/whatsapp/cloud-api/

## Database Schema Overview

### Core Tables
- users (user accounts)
- subscriptions (billing plans)
- contacts (contact database)
- groups (contact groups)
- contact_groups (many-to-many)
- templates (message templates)
- campaigns (campaign data)
- messages (sent messages)
- message_queue (pending messages)
- conversations (chat threads)
- payments (payment records)
- settings (system settings)
- analytics (metrics data)

## Security Considerations
- Password hashing with bcrypt
- CSRF protection
- SQL injection prevention (PDO prepared statements)
- XSS prevention
- Rate limiting
- API token encryption
- File upload validation
- Session security

## Installation Requirements
- PHP 8.1 or higher
- MySQL 8.0 or higher
- Apache/Nginx with mod_rewrite
- SSL certificate (required for WhatsApp webhooks)
- Cron job access
- PHP Extensions: pdo_mysql, curl, gd, mbstring, json, openssl
