<?php

return [
    'name' => 'Sender',
    'version' => '1.0.0',
    'url' => getenv('APP_URL') ?: 'http://localhost',
    'env' => getenv('APP_ENV') ?: 'production',
    'debug' => getenv('APP_DEBUG') === 'true',
    'timezone' => 'Africa/Douala',
    'locale' => 'fr_CM',
    'currency' => 'XAF',
    
    // Security
    'encryption_key' => getenv('APP_KEY') ?: '',
    
    // Session
    'session_lifetime' => 120, // minutes
    
    // File Upload
    'upload_path' => __DIR__ . '/../public/uploads/',
    'max_upload_size' => 10 * 1024 * 1024, // 10MB
    
    // Pagination
    'items_per_page' => 20,
    
    // Features (can be toggled by admin)
    'features' => [
        'contact_import' => true,
        'group_extraction' => true,
        'template_management' => true,
        'campaign_scheduling' => true,
        'bulk_sending' => true,
        'inbox' => true,
        'analytics' => true,
        'media_sending' => true,
        'api_access' => false,
    ],
    
    // Queue Settings
    'queue' => [
        'batch_size' => 50,
        'retry_attempts' => 3,
        'retry_delay' => 300, // seconds
    ],
    
    // Email Settings (for password recovery)
    'mail' => [
        'driver' => getenv('MAIL_DRIVER') ?: 'smtp',
        'host' => getenv('MAIL_HOST') ?: 'smtp.mailtrap.io',
        'port' => getenv('MAIL_PORT') ?: 2525,
        'username' => getenv('MAIL_USERNAME') ?: '',
        'password' => getenv('MAIL_PASSWORD') ?: '',
        'encryption' => getenv('MAIL_ENCRYPTION') ?: 'tls',
        'from' => [
            'address' => getenv('MAIL_FROM_ADDRESS') ?: 'noreply@sender.cm',
            'name' => getenv('MAIL_FROM_NAME') ?: 'Sender',
        ],
    ],
];
