<?php

namespace Core;

class View
{
    private $viewsPath;
    private $layoutsPath;
    private $layout = 'default';
    
    public function __construct()
    {
        $this->viewsPath = __DIR__ . '/../app/views/';
        $this->layoutsPath = $this->viewsPath . 'layouts/';
    }
    
    public function render($viewPath, $data = [])
    {
        extract($data);
        
        $viewFile = $this->viewsPath . str_replace('.', '/', $viewPath) . '.php';
        
        if (!file_exists($viewFile)) {
            throw new \Exception("View file not found: {$viewFile}");
        }
        
        ob_start();
        include $viewFile;
        $content = ob_get_clean();
        
        if ($this->layout) {
            $layoutFile = $this->layoutsPath . $this->layout . '.php';
            
            if (file_exists($layoutFile)) {
                ob_start();
                include $layoutFile;
                return ob_get_clean();
            }
        }
        
        return $content;
    }
    
    public function setLayout($layout)
    {
        $this->layout = $layout;
    }
    
    public function noLayout()
    {
        $this->layout = null;
    }
    
    public function partial($partialPath, $data = [])
    {
        extract($data);
        
        $partialFile = $this->viewsPath . str_replace('.', '/', $partialPath) . '.php';
        
        if (!file_exists($partialFile)) {
            throw new \Exception("Partial file not found: {$partialFile}");
        }
        
        include $partialFile;
    }
    
    public function escape($value)
    {
        return htmlspecialchars($value, ENT_QUOTES, 'UTF-8');
    }
    
    public function old($key, $default = '')
    {
        return Session::getOldInput($key) ?? $default;
    }
    
    public function error($key)
    {
        $errors = Session::get('errors', []);
        return $errors[$key][0] ?? null;
    }
    
    public function hasError($key)
    {
        $errors = Session::get('errors', []);
        return isset($errors[$key]);
    }
    
    public function flash($key)
    {
        return Session::get($key);
    }
}
