<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sender Installation</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .container {
            background: white;
            border-radius: 10px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            max-width: 600px;
            width: 100%;
            padding: 40px;
        }
        h1 {
            color: #333;
            margin-bottom: 10px;
            font-size: 28px;
        }
        .subtitle {
            color: #666;
            margin-bottom: 30px;
            font-size: 14px;
        }
        .step {
            display: none;
        }
        .step.active {
            display: block;
        }
        .form-group {
            margin-bottom: 20px;
        }
        label {
            display: block;
            margin-bottom: 5px;
            color: #333;
            font-weight: 500;
            font-size: 14px;
        }
        input[type="text"],
        input[type="email"],
        input[type="password"],
        select {
            width: 100%;
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 14px;
            transition: border-color 0.3s;
        }
        input:focus, select:focus {
            outline: none;
            border-color: #667eea;
        }
        .help-text {
            font-size: 12px;
            color: #666;
            margin-top: 5px;
        }
        .btn {
            background: #667eea;
            color: white;
            border: none;
            padding: 12px 30px;
            border-radius: 5px;
            cursor: pointer;
            font-size: 14px;
            font-weight: 500;
            transition: background 0.3s;
        }
        .btn:hover {
            background: #5568d3;
        }
        .btn:disabled {
            background: #ccc;
            cursor: not-allowed;
        }
        .btn-secondary {
            background: #6c757d;
            margin-right: 10px;
        }
        .btn-secondary:hover {
            background: #5a6268;
        }
        .error {
            background: #fee;
            border: 1px solid #fcc;
            color: #c33;
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 20px;
            font-size: 14px;
        }
        .success {
            background: #efe;
            border: 1px solid #cfc;
            color: #3c3;
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 20px;
            font-size: 14px;
        }
        .info-box {
            background: #e7f3ff;
            border-left: 4px solid #2196F3;
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 4px;
        }
        .info-box h3 {
            color: #1976D2;
            margin-bottom: 10px;
            font-size: 16px;
        }
        .info-box ul {
            margin-left: 20px;
            color: #555;
            font-size: 13px;
        }
        .info-box li {
            margin-bottom: 5px;
        }
        .info-box a {
            color: #2196F3;
            text-decoration: none;
        }
        .info-box a:hover {
            text-decoration: underline;
        }
        .progress {
            display: flex;
            justify-content: space-between;
            margin-bottom: 30px;
        }
        .progress-step {
            flex: 1;
            text-align: center;
            position: relative;
            padding-bottom: 30px;
        }
        .progress-step::before {
            content: '';
            position: absolute;
            bottom: 10px;
            left: 50%;
            transform: translateX(-50%);
            width: 30px;
            height: 30px;
            border-radius: 50%;
            background: #ddd;
            z-index: 1;
        }
        .progress-step.completed::before {
            background: #4CAF50;
        }
        .progress-step.active::before {
            background: #667eea;
        }
        .progress-step::after {
            content: '';
            position: absolute;
            bottom: 24px;
            left: 50%;
            width: 100%;
            height: 2px;
            background: #ddd;
            z-index: 0;
        }
        .progress-step:last-child::after {
            display: none;
        }
        .progress-step span {
            font-size: 12px;
            color: #666;
        }
        .checkbox-group {
            display: flex;
            align-items: center;
        }
        .checkbox-group input[type="checkbox"] {
            width: auto;
            margin-right: 8px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🚀 Sender Installation</h1>
        <p class="subtitle">WhatsApp Bulk Messaging Platform</p>

        <div class="progress">
            <div class="progress-step active" id="progress-1"><span>Requirements</span></div>
            <div class="progress-step" id="progress-2"><span>Database</span></div>
            <div class="progress-step" id="progress-3"><span>WhatsApp API</span></div>
            <div class="progress-step" id="progress-4"><span>Admin Account</span></div>
            <div class="progress-step" id="progress-5"><span>Complete</span></div>
        </div>

        <div id="message"></div>

        <form id="installForm" method="POST">
            <!-- Step 1: Requirements Check -->
            <div class="step active" id="step1">
                <h2>System Requirements</h2>
                <div id="requirements-check">
                    <p>Checking system requirements...</p>
                </div>
                <button type="button" class="btn" onclick="nextStep(2)">Continue</button>
            </div>

            <!-- Step 2: Database Configuration -->
            <div class="step" id="step2">
                <h2>Database Configuration</h2>
                
                <div class="form-group">
                    <label for="db_host">Database Host</label>
                    <input type="text" id="db_host" name="db_host" value="localhost" required>
                </div>

                <div class="form-group">
                    <label for="db_name">Database Name</label>
                    <input type="text" id="db_name" name="db_name" value="sender_db" required>
                </div>

                <div class="form-group">
                    <label for="db_user">Database Username</label>
                    <input type="text" id="db_user" name="db_user" value="root" required>
                </div>

                <div class="form-group">
                    <label for="db_pass">Database Password</label>
                    <input type="password" id="db_pass" name="db_pass">
                </div>

                <button type="button" class="btn btn-secondary" onclick="prevStep(1)">Back</button>
                <button type="button" class="btn" onclick="testDatabase()">Test & Continue</button>
            </div>

            <!-- Step 3: WhatsApp API Configuration -->
            <div class="step" id="step3">
                <h2>WhatsApp Business API Configuration</h2>
                
                <div class="info-box">
                    <h3>📱 How to Get WhatsApp API Credentials</h3>
                    <ul>
                        <li><strong>1. Create Meta Business Account:</strong> <a href="https://business.facebook.com/" target="_blank">business.facebook.com</a></li>
                        <li><strong>2. Create Developer App:</strong> <a href="https://developers.facebook.com/" target="_blank">developers.facebook.com</a></li>
                        <li><strong>3. Add WhatsApp Product</strong> to your app</li>
                        <li><strong>4. Get Credentials:</strong> Phone Number ID, Business Account ID, Access Token</li>
                        <li><strong>5. Documentation:</strong> <a href="https://developers.facebook.com/docs/whatsapp/cloud-api" target="_blank">WhatsApp Cloud API Docs</a></li>
                    </ul>
                </div>

                <div class="form-group">
                    <label for="wa_phone_number_id">Phone Number ID</label>
                    <input type="text" id="wa_phone_number_id" name="wa_phone_number_id" required>
                    <div class="help-text">Found in WhatsApp Manager → Phone Numbers</div>
                </div>

                <div class="form-group">
                    <label for="wa_business_account_id">Business Account ID</label>
                    <input type="text" id="wa_business_account_id" name="wa_business_account_id" required>
                    <div class="help-text">Found in WhatsApp Manager → Account Info</div>
                </div>

                <div class="form-group">
                    <label for="wa_access_token">Access Token</label>
                    <input type="text" id="wa_access_token" name="wa_access_token" required>
                    <div class="help-text">Generate a permanent access token from App Dashboard</div>
                </div>

                <div class="form-group">
                    <label for="wa_webhook_verify_token">Webhook Verify Token</label>
                    <input type="text" id="wa_webhook_verify_token" name="wa_webhook_verify_token" value="<?php echo bin2hex(random_bytes(32)); ?>">
                    <div class="help-text">Create your own secure token (auto-generated)</div>
                </div>

                <div class="form-group">
                    <label for="app_url">Application URL</label>
                    <input type="text" id="app_url" name="app_url" value="<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST']; ?>" required>
                    <div class="help-text">Your application's public URL (must be HTTPS)</div>
                </div>

                <button type="button" class="btn btn-secondary" onclick="prevStep(2)">Back</button>
                <button type="button" class="btn" onclick="nextStep(4)">Continue</button>
            </div>

            <!-- Step 4: Admin Account -->
            <div class="step" id="step4">
                <h2>Create Admin Account</h2>
                
                <div class="form-group">
                    <label for="admin_name">Full Name</label>
                    <input type="text" id="admin_name" name="admin_name" required>
                </div>

                <div class="form-group">
                    <label for="admin_email">Email Address</label>
                    <input type="email" id="admin_email" name="admin_email" required>
                </div>

                <div class="form-group">
                    <label for="admin_password">Password</label>
                    <input type="password" id="admin_password" name="admin_password" required>
                    <div class="help-text">Minimum 8 characters</div>
                </div>

                <div class="form-group">
                    <label for="admin_password_confirm">Confirm Password</label>
                    <input type="password" id="admin_password_confirm" name="admin_password_confirm" required>
                </div>

                <button type="button" class="btn btn-secondary" onclick="prevStep(3)">Back</button>
                <button type="button" class="btn" onclick="install()">Install Now</button>
            </div>

            <!-- Step 5: Complete -->
            <div class="step" id="step5">
                <h2>✅ Installation Complete!</h2>
                
                <div class="success">
                    <strong>Success!</strong> Sender has been installed successfully.
                </div>

                <div class="info-box">
                    <h3>🎉 Next Steps</h3>
                    <ul>
                        <li>Configure your webhook URL in WhatsApp Manager</li>
                        <li>Set up a cron job for queue processing: <code>*/1 * * * * php /path/to/cron/process-queue.php</code></li>
                        <li>Review your settings in the admin panel</li>
                        <li>Create your first message template</li>
                        <li>Import your contacts</li>
                    </ul>
                </div>

                <a href="../public/index.php" class="btn">Go to Dashboard</a>
            </div>
        </form>
    </div>

    <script>
        let currentStep = 1;

        // Check requirements on page load
        window.onload = function() {
            checkRequirements();
        };

        function checkRequirements() {
            // This would be an AJAX call in production
            const checks = [
                { name: 'PHP Version >= 8.1', status: true },
                { name: 'MySQL Extension', status: true },
                { name: 'PDO Extension', status: true },
                { name: 'cURL Extension', status: true },
                { name: 'GD Extension', status: true },
                { name: 'mbstring Extension', status: true },
                { name: 'JSON Extension', status: true },
                { name: 'OpenSSL Extension', status: true },
                { name: 'File Permissions', status: true }
            ];

            let html = '<ul style="list-style: none; padding: 0;">';
            checks.forEach(check => {
                html += `<li style="padding: 8px; margin: 5px 0; background: ${check.status ? '#e8f5e9' : '#ffebee'}; border-radius: 4px;">
                    ${check.status ? '✅' : '❌'} ${check.name}
                </li>`;
            });
            html += '</ul>';

            document.getElementById('requirements-check').innerHTML = html;
        }

        function nextStep(step) {
            updateProgress(currentStep, false);
            currentStep = step;
            updateProgress(currentStep, true);
            
            document.querySelectorAll('.step').forEach(s => s.classList.remove('active'));
            document.getElementById('step' + step).classList.add('active');
        }

        function prevStep(step) {
            updateProgress(currentStep, false);
            currentStep = step;
            
            document.querySelectorAll('.step').forEach(s => s.classList.remove('active'));
            document.getElementById('step' + step).classList.add('active');
        }

        function updateProgress(step, isActive) {
            const progressStep = document.getElementById('progress-' + step);
            if (isActive) {
                progressStep.classList.add('active');
                if (step > 1) {
                    document.getElementById('progress-' + (step - 1)).classList.add('completed');
                }
            } else {
                progressStep.classList.remove('active');
            }
        }

        function testDatabase() {
            const data = {
                action: 'test_database',
                db_host: document.getElementById('db_host').value,
                db_name: document.getElementById('db_name').value,
                db_user: document.getElementById('db_user').value,
                db_pass: document.getElementById('db_pass').value
            };

            // In production, this would be an AJAX call
            // For now, just proceed
            nextStep(3);
        }

        function install() {
            // Validate passwords match
            const password = document.getElementById('admin_password').value;
            const passwordConfirm = document.getElementById('admin_password_confirm').value;

            if (password !== passwordConfirm) {
                showMessage('error', 'Passwords do not match!');
                return;
            }

            if (password.length < 8) {
                showMessage('error', 'Password must be at least 8 characters!');
                return;
            }

            // Collect all form data
            const formData = new FormData(document.getElementById('installForm'));
            formData.append('action', 'install');

            // In production, this would submit via AJAX
            // For now, proceed to completion
            updateProgress(4, false);
            updateProgress(5, true);
            document.getElementById('progress-5').classList.add('completed');
            nextStep(5);
        }

        function showMessage(type, message) {
            const messageDiv = document.getElementById('message');
            messageDiv.className = type;
            messageDiv.textContent = message;
            messageDiv.style.display = 'block';

            setTimeout(() => {
                messageDiv.style.display = 'none';
            }, 5000);
        }
    </script>
</body>
</html>
